#
# include file for Makefile in sub-directories.
#
export TARGET?=mipsel-linux
export ARCH?=mips
#export TARGET?=powerpc-linux
#export ARCH?=powerpc
export CROSS?=$(TARGET)-
export CPU?=$(ARCH)
export LINUX?=/usr/local/$(TARGET)
export TOOLROOT?=/usr/local/$(TARGET)
export FTP?=wget --passive-ftp
#export FTP?=wget

AS=$(CROSS)as
LD=$(CROSS)ld
CC=$(CROSS)gcc
CXX=$(CROSS)c++
AR=$(CROSS)ar
NM=$(CROSS)nm
STRIP=$(CROSS)strip
RANLIB=$(CROSS)ranlib
PATCH=patch


ifeq ($(COREGALINUX_BASEDIR),)
	COREGALINUX_BASEDIR=$(shell pwd)/../
endif

export AS LD CC CXX AR NM STRIP RANLIB PATCH

ifeq ($(DISTDIR),)
	DISTDIR:=$(COREGALINUX_BASEDIR)/distfiles
else
	ifneq ($(shell echo $(DISTDIR) | cut -c 1),/)
		override DISTDIR:=$(shell pwd)/$(DISTDIR)
	endif
endif
ifeq ($(INSTDIR),)
	INSTDIR:=$(COREGALINUX_BASEDIR)/install_root
else
	ifneq ($(shell echo $(INSTDIR) | cut -c 1),/)
		override INSTDIR:=$(shell pwd)/$(INSTDIR)
	endif
endif
ifeq ($(WORKDIR),)
	WORKDIR:=$(shell pwd)/work
else
	ifneq ($(shell echo $(WORKDIR) | cut -c 1),/)
		override WORKDIR:=$(shell pwd)/$(WORKDIR)
	endif
endif

WORKDIST=$(WORKDIR)/$(DISTDIRNAME)

export DISTDIR INSTDIR WORKDIR WORKDIST

$(DISTDIR)/$(DISTFILENAME):
	cd $(DISTDIR) && $(FTP) $(DISTLOCATION)
	echo "$(DISTFILENAME)	$(DISTLOCATION)" >> $(DISTDIR)/LOCATIONS

_source: $(DISTDIR)/$(DISTFILENAME)
	-test -d $(WORKDIR) || mkdir $(WORKDIR)
	if (file $^ | grep bzip2) > /dev/null 2>&1; then	\
		bzcat $^ | tar -C $(WORKDIR) -xvf -;	\
	else						\
		zcat $^ | tar -C $(WORKDIR) -xvf -;	\
	fi

_default:
	make -C $(WORKDIST)

_install:
	make -C $(WORKDIST) install

_clean:
	-make -C $(WORKDIST) clean

_clean-source:
	-rm -rf $(WORKDIST)
	-rmdir $(WORKDIR)

.PHONY: source static shared install_static install_shared clean clean-source

