#!/bin/sh

while [ $# -ge 1 ]; do
	case $1 in 
	-f)
		if [ $# -lt 1 ]; then
			echo "-f takes an argument"
			exit 1
		fi
		shift
		FSTYPE=$1
		;;
	-i)
		if [ $# -lt 1 ]; then
			echo "-i takes an argument"
			exit 1
		fi
		shift
		INSTDIR=$1
		;;
	-h)
		continue;
		;;
	-*)
		echo "unknown option $1"
		exit 1
		;;
	*)
		break;
	esac
	shift
done

if [ $# -lt 1 ]; then
	echo "usage:  buildimg_initrd.sh [-i ROOT] [-f FSTYPE] IMAGENAME [SIZE(KB)]"
	exit 1
fi

IMAGE=`echo $1 | sed s/\.gz\$//`
if [ "X$2" != X ]; then
	SIZE=$2
else
	SIZE=12288
fi

if [ "X$INSTDIR" = X ]; then
	INSTDIR=install_root
fi

if [ "X$FSTYPE" = X -o "X$FSTYPE" = Xext2 ]; then
	FSTYPE="ext2 -m 0 -F"
fi

dd if=/dev/zero of=$IMAGE bs=1024 count=$SIZE || exit 1
mkfs -t ${FSTYPE} $IMAGE || exit 1

_MNT_=`echo $IMAGE | sed "s/\//_/g"`
MNT=`mktemp -d /tmp/$_MNT_.XXXXXX`
test $? -ne 0 && exit 1 

for i in 0 1 2 3 4 5 6 7 ; do
	mount -oloop=/dev/loop$i $IMAGE $MNT && break
done
if [ $? -ne 0 ]; then
	echo "failed to mount $IMAGE"
	exit 1 
fi

#tar -C $INSTDIR -cf - . | tar -C $MNT -xpf -
(cd $INSTDIR && cp -a . $MNT) || exit

if [ ! -f "$MNT/etc/fstab" ]; then
	if [ -f "$MNT/etc/fstab.initrd" ]; then
		echo "fstab.initrd --> fstab"
		(cd "$MNT/etc" && ln -sf fstab.initrd fstab ) || exit $?
	else
		touch "$MNT/etc/fstab"
	fi
fi

sync
umount $MNT
rmdir $MNT

rm -f $IMAGE.gz
gzip -9 $IMAGE

