#!/bin/sh

ERASESIZE=128k

while [ $# -ge 1 ]; do
	case $1 in 
	-e)
		if [ $# -lt 1 ]; then
			echo "-e takes an argument"
			exit 1
		fi
		shift
		ERASESIZE=$1
		;;
	-i)
		if [ $# -lt 1 ]; then
			echo "-i takes an argument"
			exit 1
		fi
		shift
		INSTDIR=$1
		;;
	-h)
		continue;
		;;
	-*)
		echo "unknown option $1"
		exit 1
		;;
	*)
		break;
	esac
	shift
done

if [ $# -lt 1 ]; then
	echo "usage:  buildimg_jffs2.sh [-i ROOT] [-e erasesize] IMAGENAME [SIZE(KB)]"
	exit 1
fi

IMAGE=$1
if [ X$2 != X ]; then
	SIZE=$2
	PADOP=" -p `expr $SIZE \* 1024`"
else
	SIZE=""
	PADOP=""
fi

if [ X$INSTDIR = X ]; then
	INSTDIR=install_root
fi

if [ ! -f $INSTDIR/etc/fstab ]; then
	FSTAB="new"
	if [ -f $INSTDIR/etc/fstab.jffs2 ]; then
		echo "fstab.jffs2 --> fstab"
		(cd $INSTDIR/etc && ln -sf fstab.jffs2 fstab) || exit $?
	else
		touch $INSTDIR/etc/fstab
	fi
else
	FSTAB="keep"
fi

/usr/local/sbin/mkfs.jffs2 -e $ERASESIZE -l -o $IMAGE -d $INSTDIR $PADOP

if [ X$FSTAB = "new" ]; then
	rm $INSTDIR/etc/fstab
fi

