#!/bin/sh

if [ X${INSTDIR} = X ]; then
	echo "no INSTDIR passed"
	exit 1
fi

if [ $# -lt 2 ]; then
	echo "usage: install_files.sh SRCDIR FILELIST"
	exit 1
fi

SRCDIR=$1
FILELIST=$2

if [ ! -f ${FILELIST} ]; then
	echo "cannot read ${FILELIST}"
	exit 1;
fi

echo "copying files from ${SRCDIR} to ${INSTDIR}"

FILES=`cat ${FILELIST} | sed -e 's/\#.*//' -e '/^\n/d'`

for f in ${FILES}; do
	if [ -d ${SRCDIR}/$f ]; then
		echo "mkdir -p $INSTDIR/$f"
		if [ ! -d ${INSTDIR}/$f ]; then
			mkdir -p ${INSTDIR}/$f || exit $?
			echo
		fi
	else
		echo "${SRCDIR}/$f --> ${INSTDOR}/$f"
		rm -f ${INSTDIR}/$f
		(cd ${SRCDIR} && tar cf - $f) | tar -C ${INSTDIR} -xSpf - || exit $?
		if (file -b ${INSTDIR}/$f | grep ELF | grep "not stripped") > /dev/null 2>&1; then
			chmod 755 $INSTDIR/$f
			$STRIP $INSTDIR/$f
		fi
	fi
done

