/*
 * arch/mips/adm5120/mcard5120/adm5120_ds1305_io.c
 * 
 *	DS1305 3wire interface for MCARD5120 ether status LED port.
 *	Though it isn't SPI, they have spi_ prefix for ds1305.c
 *	
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2004 MegaSolution Inc.
 * Author: m_sato@megasolution.jp
 */

#if 0
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <asm/system.h>
#include <asm/delay.h>
#include <asm/io.h>
#include <asm/bootinfo.h>
#include <asm/adm5120/adm5120.h>
#endif
#include <common.h>
#include <command.h>
#include <adm51xx_switch.h>
#include <asm/addrspace.h>
#include <pci.h>
#include <asm/io.h>
#include <asm/adm5120.h>

#define RTC_PORT	4

extern int machineid;

#define CE	0
#define	SCLK	1
#define IO	2

#define _HIGH	GPIOL_OUTPUT_LOW
#define _LOW	GPIOL_OUTPUT_HIGH

#ifdef DEBUG

static inline void print_state(int port)
{
	u_int32_t tmp;
	unsigned long addr;
	
	addr = SWITCH + SWITCH_PORT0_LED + port * 4;
	tmp = (readl((void *)KSEG1ADDR(addr)) >> 12) & 0x7;
	if ((tmp & 1) == 0) {
		printk("X");
		return;
	}
	switch (tmp & 6) {
	default:
		printk("_");
		break;
	case 6:
		printk("=");
		break;
	case 4:
		printk("-");
		break;
	case 2:
		printk("^");
		break;
	}
}
#else
static inline void print_state(int port)
{
}
#endif


static int led_port(int port, int num, int state)
{
	u_int32_t tmp, mask;
	void *addr;
	
	addr = (void *)KSEG1ADDR(SWITCH + SWITCH_PORT0_LED + port * 4);
	mask = 0xf << (num * 4);

	tmp = readl(addr) & ~mask;
	writel(tmp | (state << (num * 4)), addr);

	return (readl(addr) >> (12 + num)) & 0x1;
}


static inline void send_bit(int bit)
{
	led_port(RTC_PORT, SCLK, _LOW);
	print_state(RTC_PORT);
	udelay(100);
	led_port(RTC_PORT, IO, (bit) ? _HIGH : _LOW);
	print_state(RTC_PORT);
	udelay(100);
	led_port(RTC_PORT, SCLK, _HIGH);
	print_state(RTC_PORT);
	udelay(100);
}

static inline int recv_bit(void)
{
	int bit;

	led_port(RTC_PORT, SCLK, _HIGH);
	print_state(RTC_PORT);
	udelay(100);
	led_port(RTC_PORT, SCLK, _LOW);
	print_state(RTC_PORT);
	udelay(100);
	bit = led_port(RTC_PORT, IO, GPIOL_INPUT_MODE);
	print_state(RTC_PORT);

	return bit;
}


void
spi_enable()
{
	led_port(RTC_PORT, CE, _HIGH);
	led_port(RTC_PORT, SCLK, _LOW);
	led_port(RTC_PORT, IO, _LOW);
	print_state(RTC_PORT);
#ifdef DEBUG
	printk("\n");
#endif
}



void
spi_disable()
{
	led_port(RTC_PORT, CE, _LOW);
	led_port(RTC_PORT, SCLK, _LOW);
	led_port(RTC_PORT, IO, _LOW);
	print_state(RTC_PORT);
#ifdef DEBUG
	printk("\n");
#endif
}



int
spi_open(int param)
{
	spi_enable();

	return 0;
}



void
spi_close()
{
	spi_disable();
}



void
spi_exchange(u_int8_t *data, int count)
{
	/* since it is in 3 wire mode, it can't support exchange */
	spi_write(data, 1);
	spi_read(data + 1, count - 1);
}


void
spi_write(u_int8_t *data, int count)
{
	u_int8_t tmp;
	int i, j;

	for (i = 0; i < count; i++) {
		tmp = data[i];
		for (j = 0; j < 8; j++) {
			send_bit(tmp & 1);
			tmp >>= 1;
		}
	}
}


void
spi_read(u_int8_t *data, int count)
{
	u_int8_t tmp;
	int i, j;

	led_port(RTC_PORT, IO, GPIOL_INPUT_MODE);
#ifdef DEBUG
	printk(" ");
#endif
	for (i = 0; i < count; i++) {
		tmp = 0;
		for (j = 0; j < 8; j++) {
			tmp >>= 1;
			if (recv_bit())
				tmp |= 0x80;
		}
		data[i] = tmp;
#ifdef DEBUG
		printk(" : %2x\n", tmp);
#endif
	}
}

