/*
 * Board initialize code for ADMtek/Infineon adm5120 SoC.
 *
 * (C) Copyright 2007 Liberty System Factory
 *   Tooru Yoshida, <yoshida@libertysystem-factory.co.jp>
 *
 * (C) Copyright 2006
 * Robert Delien, <robert@delien.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <adm51xx_switch.h>
#include <asm/addrspace.h>
#include <pci.h>
#include <asm/io.h>

#if defined(CONFIG_PCI)
static struct pci_controller hose;

void pci_init_board (void)
{
	init_adm5120_pci(&hose);
}
#endif


long int initdram(int board_type)
{
/*	TODO: Make this work with CFG_SDRAM_MAX */
	/* Corega VPN-BOX SDRAM CFG_SDRAM_MAX */
	return get_ram_size ((void*)CFG_SDRAM_BASE, CFG_SDRAM_MAX);
}


int checkboard (void)
{
	unsigned int value;
	unsigned int mask;

	printf("SoC:   Corega CG-LBSTD2PU(ADM5120)");
	if (readl(SWITCH + SWITCH_CODE) & SWITCH_CODE__PK)
		printf("/PQFP");
	else
		printf("/BGA");
	printf(" @%dMHz ", (int)CPU_CLOCK_RATE/1000000);

	mask = SWITCH_CODE__REV ;
	value = readl(SWITCH + SWITCH_CODE) & mask ;
	while ((mask & 1) == 0) {
		mask >>= 1 ;
		value >>= 1 ;
	}
	printf("(Rev: %04X)\n", value);
	/*
	 * DS1305 RTC Initalize
	 *  Append 2008.03.14 T.Yoshida
	 */
#ifdef CONFIG_ADM5120_RTC
	ds1305_init(0);
#endif

	return 0;
}
