/*
 * + * ADM5120 PCI bridge support code
 * + *
 * + * (C) Copyright 2006 Masami Komiya <mkomiya@sonare.it>
 * + *
 * + * This program is free software; you can redistribute it and/or
 * + * modify it under the terms of the GNU General Public License as
 * + * published by the Free Software Foundation; either version 2, or (at
 * + * your option) any later version.
 * + */

#include <common.h>
#include <pci.h>
#include <asm/addrspace.h>

#if defined(CONFIG_ADM5120) && defined(CONFIG_PCI)

#define ADM5120_PCICONFAREG    (volatile unsigned int*)(KSEG1 + 0x115ffff0)
#define ADM5120_PCICONFDREG    (volatile unsigned int*)(KSEG1 + 0x115ffff8)

#define ADM5120_PCI_ENABLE     0x80000000

#define PCI_ACCESS_READ  0
#define PCI_ACCESS_WRITE 1

/*
 *     Access PCI Configuration Register for ADM5120
 */

static int adm5120_pci_config_access (u8 access_type, u32 dev, u32 reg,
                                    u32 * data)
{
       *ADM5120_PCICONFAREG = (u32) (dev | ((reg / 4) << 2) | ADM5120_PCI_ENABLE);

       if (access_type == PCI_ACCESS_WRITE) {
               *ADM5120_PCICONFDREG = *data;
       } else {
               *data = *ADM5120_PCICONFDREG;
       }

       return (0);
}


static int adm5120_pci_read_config_dword (struct pci_controller *hose,
                                        pci_dev_t dev, u32 reg, u32 * val)
{
       u32 data = 0;

       if (reg & 3)
               return -1;

       if (adm5120_pci_config_access (PCI_ACCESS_READ, dev, reg, &data))
               return -1;

       *val = data;

       return (0);
}
static int adm5120_pci_write_config_dword (struct pci_controller *hose,
                                         pci_dev_t dev, u32 reg, u32 val)
{
       u32 data;

       if (reg & 3) {
               return -1;
       }

       data = val;

       if (adm5120_pci_config_access (PCI_ACCESS_WRITE, dev, reg, &data))
               return -1;

       return (0);
}

/*
 *     Initialize Module
 */

void init_adm5120_pci (struct pci_controller *hose)
{
       hose->first_busno = 0;
       hose->last_busno = 0xff;

       /* PCI memory space */
       pci_set_region (hose->regions + 0,
                       0x11400000, 0xb1400000, 0x00100000, PCI_REGION_MEM);


      /* PCI I/O space */
       pci_set_region (hose->regions + 1,
                       0x11500000, 0xb1500000, 0x00100000, PCI_REGION_IO);

       /* System memory space */
       pci_set_region (hose->regions + 2,
                       0x00000000,
                       0x80000000,
                       0x02000000, PCI_REGION_MEM | PCI_REGION_MEMORY);

       hose->region_count = 3;

       pci_set_ops(hose,
                   pci_hose_read_config_byte_via_dword,
                   pci_hose_read_config_word_via_dword,
                   adm5120_pci_read_config_dword,
                   pci_hose_write_config_byte_via_dword,
                   pci_hose_write_config_word_via_dword,
                   adm5120_pci_write_config_dword);

       pci_register_hose (hose);

       hose->last_busno = pci_hose_scan (hose);

       return;
}

#endif
