/*
 * Definitions for memory memory map of
 * ADMtek/Infineon adm5120 SoC.
 *
 * (C) Copyright 2006
 * Robert Delien, <robert@delien.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef ADM5120_GLB_H
#define ADM5120_GLB_H

#define TO_PHYSICAL(addr)		((unsigned long)(addr) & 0x1FFFFFFFUL)
#define TO_UNCACHED(addr)		((unsigned long)(addr) | 0xA0000000UL)
#define TO_CACHED(addr)			((unsigned long)(addr) | 0x80000000UL)

#define UART_1				0xB2800000
#define UART_0				0xB2600000
#define INTC				0xB2200000
#define SWITCH				0xB2000000
#define MPMC				0xB1000000

#endif /* ADM5120_GLB_H */
