/*
 * Register definitions for switch controller of
 * ADMtek/Infineon adm5120 and adm5106 SoC.
 *
 * (C) Copyright 2006
 * Robert Delien, <robert@delien.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef ADM51xx_SWITCH_H
#define ADM51xx_SWITCH_H

/*
 * Layout of Switch registers
 */
#define SWITCH_CODE			0x00000000
#define SWITCH_SFT_RES			0x00000004
#define SWITCH_BOOT_D			0x00000008
#define SWITCH_SW_RES			0x0000000C
#define SWITCH_PHY_ST			0x00000014
#define SWITCH_PORT_ST			0x00000018
#define SWITCH_MEM_CONT			0x0000001C
#define SWITCH_SW_CONF			0x00000020
#define SWITCH_CPUP_CONF		0x00000024
#define SWITCH_PORT_CONF0		0x00000028
#define SWITCH_PORT_CONF1		0x0000002C
#define SWITCH_PORT_CONF2		0x00000030
#define SWITCH_RES_1			0x00000034
#define SWITCH_RES_2			0x00000038
#define SWITCH_RES_3			0x0000003C
#define SWITCH_VLAN_GI			0x00000040
#define SWITCH_VLAN_GII			0x00000044
#define SWITCH_SEND_TRIG		0x00000048
#define SWITCH_SRCH_CMD			0x0000004C
#define SWITCH_ADDR_ST0			0x00000050
#define SWITCH_ADDR_ST1			0x00000054
#define SWITCH_MAC_WT0			0x00000058
#define SWITCH_MAC_WT1			0x0000005C
#define SWITCH_BW_CNTL0			0x00000060
#define SWITCH_BW_CNTL1			0x00000064
#define SWITCH_PHY_CNTL0		0x00000068
#define SWITCH_PHY_CNTL1		0x0000006C
#define SWITCH_FC_TH			0x00000070
#define SWITCH_ADJ_PORT_TH		0x00000074
#define SWITCH_PORT_TH			0x00000078
#define SWITCH_PHY_CNTL2		0x0000007C
#define SWITCH_PHY_CNTL3		0x00000080
#define SWITCH_PRI_CNTL			0x00000084
#define SWITCH_VLAN_PRI			0x00000088
#define SWITCH_TOS_EN			0x0000008C
#define SWITCH_TOS_MAP0			0x00000090
#define SWITCH_TOS_MAP1			0x00000094
#define SWITCH_CUSTOM_PRI1		0x00000098
#define SWITCH_CUSTOM_PRI2		0x0000009C
#define SWITCH_PHY_CNTL4		0x000000A0
#define SWITCH_EMPTY_CNT		0x000000A4
#define SWITCH_PORT_CNT_SEL		0x000000A8
#define SWITCH_PORT_CNT			0x000000AC
#define SWITCH_INT_ST			0x000000B0
#define SWITCH_INT_MASK			0x000000B4
#define SWITCH_GPIO_CONF0		0x000000B8
#define SWITCH_GPIO_CONF2		0x000000BC
#define SWITCH_WDOG_0			0x000000C0
#define SWITCH_WDOG_1			0x000000C4
#define SWITCH_SWAP_IN			0x000000C8
#define SWITCH_SWAP_OUT			0x000000CC
#define SWITCH_SEND_HBADDR		0x000000D0
#define SWITCH_SEND_LBADDR		0x000000D4
#define SWITCH_REC_HBADDR		0x000000D8
#define SWITCH_REC_LBADDR		0x000000DC
#define SWITCH_SEND_HWADDR		0x000000E0
#define SWITCH_SEND_LWADDR		0x000000E4
#define SWITCH_REC_HWADDR		0x000000E8
#define SWITCH_REC_LWADDR		0x000000EC
#define SWITCH_TIMER_INT		0x000000F0
#define SWITCH_TIMER			0x000000F4
#define SWITCH_RES_4			0x000000F8
#define SWITCH_RES_5			0x000000FC
#define SWITCH_PORT0_LED		0x00000100
#define SWITCH_PORT1_LED		0x00000104
#define SWITCH_PORT2_LED		0x00000108
#define SWITCH_PORT3_LED		0x0000010C
#define SWITCH_GL_ST			0x00000010
#define SWITCH_PORT4_LED		0x00000110

/*
 * Generic macros
 */
#define SWITCH__PHYS_PORTS		5
#define SWITCH__VLAN_PORTS		6
#define SWITCH__PORT_0			0x01
#define SWITCH__PORT_1			0x02
#define SWITCH__PORT_2			0x04
#define SWITCH__PORT_3			0x08
#define SWITCH__PORT_4			0x10
#define SWITCH__PORTS_PHYS		(SWITCH__PORT_0		|\
					 SWITCH__PORT_1		|\
					 SWITCH__PORT_2		|\
					 SWITCH__PORT_3		|\
					 SWITCH__PORT_4)
#define SWITCH__PORT_GIGA		0x20
#define SWITCH__PORTS_NET		(SWITCH__PORTS_PHYS	|\
					 SWITCH__PORT_GIGA)
#define SWITCH__PORT_CPU		0x40
#define SWITCH__PORTS_ALL		(SWITCH__PORTS_NET	|\
					 SWITCH__PORT_CPU)

/*
 * Code register fields
 */
#define SWITCH_CODE__PK			(0x00000001<<29)
#define SWITCH_CODE__CLKS		(0x00000003<<20)
#define SWITCH_CODE__CLKS_175MHZ	(0x00000000<<20)
#define SWITCH_CODE__CLKS_200MHZ	(0x00000001<<20)
#define SWITCH_CODE__CLKS_RES1		(0x00000002<<20)
#define SWITCH_CODE__CLKS_RES2		(0x00000003<<20)
#define SWITCH_CODE__REV		(0x0000000F<<16)
#define SWITCH_CODE__PC			(0x0000FFFF<<0)

/*
 * CPU port configuration register fields
 */
#define SWITCH_CPUP_CONF__DBCP		(SWITCH__PORTS_NET<<24)
#define SWITCH_CPUP_CONF__DBCP_SET(set)	(((set)&(SWITCH__PORTS_NET))<<24)
#define SWITCH_CPUP_CONF__DMCP		(SWITCH__PORTS_NET<<16)
#define SWITCH_CPUP_CONF__DMCP_SET(set)	(((set)&(SWITCH__PORTS_NET))<<16)
#define SWITCH_CPUP_CONF__DUNP		(SWITCH__PORTS_NET<<9)
#define SWITCH_CPUP_CONF__DUNP_SET(set)	(((set)&(SWITCH__PORTS_NET))<<9)
#define SWITCH_CPUP_CONF__BTM		(0x00000001<<2)
#define SWITCH_CPUP_CONF__CRCP		(0x00000001<<1)
#define SWITCH_CPUP_CONF__DCPUP		(0x00000001<<0)

/*
 * Port configuration 0 register fields
 */
#define SWITCH_PORT_CONF0__EBP		(SWITCH__PORTS_NET<<16)
#define SWITCH_PORT_CONF0__EBP_SET(set)	(((set)&(SWITCH__PORTS_NET))<<16)
#define SWITCH_PORT_CONF0__EMCP		(SWITCH__PORTS_NET<<8)
#define SWITCH_PORT_CONF0__EMCP_SET(set)(((set)&(SWITCH__PORTS_NET))<<8)
#define SWITCH_PORT_CONF0__DP		(SWITCH__PORTS_NET<<0)
#define SWITCH_PORT_CONF0__DP_SET(set)	(((set)&(SWITCH__PORTS_NET))<<0)

/*
 * Port configuration 1 register fields
 */
#define SWITCH_PORT_CONF1__SASM		(SWITCH__PORTS_NET<<26)
#define SWITCH_PORT_CONF1__SASM_SET(set) (((set)&(SWITCH__PORTS_NET))<<26)
#define SWITCH_PORT_CONF1__PA		(SWITCH__PORTS_NET<<20)
#define SWITCH_PORT_CONF1__PA_SET(set)	(((set)&(SWITCH__PORTS_NET))<<20)
#define SWITCH_PORT_CONF1__BM		(SWITCH__PORTS_NET<<12)
#define SWITCH_PORT_CONF1__BM_SET(set)	(((set)&(SWITCH__PORTS_NET))<<12)
#define SWITCH_PORT_CONF1__BS		(SWITCH__PORTS_NET<<6)
#define SWITCH_PORT_CONF1__BS_SET(set)	(((set)&(SWITCH__PORTS_NET))<<6)
#define SWITCH_PORT_CONF1__DISL		(SWITCH__PORTS_NET<<0)
#define SWITCH_PORT_CONF1__DISL_SET(set) (((set)&(SWITCH__PORTS_NET))<<0)

/*
 * Port configuration 2 register fields
 */
#define SWITCH_PORT_CONF2__DUPF		(SWITCH__PORTS_NET<<18)
#define SWITCH_PORT_CONF2__DUPF_SET(set) (((set)&(SWITCH__PORTS_NET))<<18)
#define SWITCH_PORT_CONF2__LEDFT	(0x00000003<<16)
#define SWITCH_PORT_CONF2__LEDFT_30	(0x00000000<<16)
#define SWITCH_PORT_CONF2__LEDFT_60	(0x00000001<<16)
#define SWITCH_PORT_CONF2__LEDFT_240	(0x00000002<<16)
#define SWITCH_PORT_CONF2__LEDFT_480	(0x00000003<<16)
#define SWITCH_PORT_CONF2__CER		(0x00000003<<9)
#define SWITCH_PORT_CONF2__CER_0	(0x00000000<<9)
#define SWITCH_PORT_CONF2__CER_1	(0x00000001<<9)
#define SWITCH_PORT_CONF2__CER_2	(0x00000002<<9)
#define SWITCH_PORT_CONF2__CER_3	(0x00000003<<9)
#define SWITCH_PORT_CONF2__TXCC		(0x00000001<<8)
#define SWITCH_PORT_CONF2__RMIIM	(0x00000001<<7)
#define SWITCH_PORT_CONF2__FMPFC	(0x00000003<<4)
#define SWITCH_PORT_CONF2__FMPFC_RX	(0x00000001<<4)
#define SWITCH_PORT_CONF2__FMPFC_TX	(0x00000002<<4)
#define SWITCH_PORT_CONF2__FMPFC_RXTX	(0x00000003<<4)
#define SWITCH_PORT_CONF2__FMDP		(0x00000001<<3)
#define SWITCH_PORT_CONF2__FMPS		(0x00000003<<1)
#define SWITCH_PORT_CONF2__FMPS_10M	(0x00000000<<1)
#define SWITCH_PORT_CONF2__FMPS_100M	(0x00000001<<1)
#define SWITCH_PORT_CONF2__FMPS_1G	(0x00000002<<1)
#define SWITCH_PORT_CONF2__GMIIAN	(0x00000001<<0)

/*
 * VLAN Group 1 register fields
 */
#define SWITCH_VLAN_GI__VLAN3		(SWITCH__PORTS_ALL<<24)
#define SWITCH_VLAN_GI__VLAN3_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<24)
#define SWITCH_VLAN_GI__VLAN2		(SWITCH__PORTS_ALL<<16)
#define SWITCH_VLAN_GI__VLAN2_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<16)
#define SWITCH_VLAN_GI__VLAN1		(SWITCH__PORTS_ALL<<8)
#define SWITCH_VLAN_GI__VLAN1_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<8)
#define SWITCH_VLAN_GI__VLAN0		(SWITCH__PORTS_ALL<<0)
#define SWITCH_VLAN_GI__VLAN0_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<0)

/*
 * VLAN Group 2 register fields
 */
#define SWITCH_VLAN_GII__VLAN5		(SWITCH__PORTS_ALL<<8)
#define SWITCH_VLAN_GII__VLAN5_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<8)
#define SWITCH_VLAN_GII__VLAN4		(SWITCH__PORTS_ALL<<0)
#define SWITCH_VLAN_GII__VLAN4_SET(set)	(((set)&(SWITCH__PORTS_ALL))<<0)

/*
 * Send trigger register fields
 */
#define SWITCH_SEND_TRIG__STH		(0x00000001<<1)
#define SWITCH_SEND_TRIG__STL		(0x00000001<<0)

/*
 * MAC Write Address 0 register fields
 */
#define SWITCH_MAC_WT0__MWA		(0x0000FFFF<<16)
#define SWITCH_MAC_WT0__MWA_B0(b0)	(((b0)&(0xFF))<<16)
#define SWITCH_MAC_WT0__MWA_B1(b1)	(((b1)&(0xFF))<<24)
#define SWITCH_MAC_WT0__WAF		(0x00000007<<13)
#define SWITCH_MAC_WT0__WAF_SET(set)	(((set)&(0x00000007))<<13)
#define SWITCH_MAC_WT0__WPMN		(0x0000003F<<7)
#define SWITCH_MAC_WT0__WPMN_SET(set)	(((set)&(0x0000003F))<<7)
#define SWITCH_MAC_WT0__WVE		(0x00000001<<6)
#define SWITCH_MAC_WT0__WVN		(0x00000007<<3)
#define SWITCH_MAC_WT0__WVN_SET(set)	(((set)&(0x00000007))<<3)
#define SWITCH_MAC_WT0__WFB		(0x00000001<<2)
#define SWITCH_MAC_WT0__MWD		(0x00000001<<1)
#define SWITCH_MAC_WT0__MAWC		(0x00000001<<0)

/*
 * MAC Write Address 1 register fields
 */
#define SWITCH_MAC_WT1__MWA		(0xFFFFFFFF<<0)
#define SWITCH_MAC_WT1__MWA_B5(b5)	(((b5)&(0xFF))<<24)
#define SWITCH_MAC_WT1__MWA_B4(b4)	(((b4)&(0xFF))<<16)
#define SWITCH_MAC_WT1__MWA_B3(b3)	(((b3)&(0xFF))<<8)
#define SWITCH_MAC_WT1__MWA_B2(b2)	(((b2)&(0xFF))<<0)

/*
 * PHY Control 2 register fields
 */
#define SWITCH_PHY_CNTL2__RES1		(0x00000001<<31)
#define SWITCH_PHY_CNTL2__RMAE		(0x00000001<<30)
#define SWITCH_PHY_CNTL2__AMDIX		(SWITCH__PORTS_PHYS<<25)
#define SWITCH_PHY_CNTL2__AMDIX_SET(set) (((set)&(SWITCH__PORTS_PHYS))<<25)
#define SWITCH_PHY_CNTL2__PHYR		(SWITCH__PORTS_PHYS<<20)
#define SWITCH_PHY_CNTL2__PHYR_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<20)
#define SWITCH_PHY_CNTL2__RFCV		(SWITCH__PORTS_PHYS<<15)
#define SWITCH_PHY_CNTL2__RFCV_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<15)
#define SWITCH_PHY_CNTL2__DC		(SWITCH__PORTS_PHYS<<10)
#define SWITCH_PHY_CNTL2__DC_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<10)
#define SWITCH_PHY_CNTL2__SC		(SWITCH__PORTS_PHYS<<5)
#define SWITCH_PHY_CNTL2__SC_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<5)
#define SWITCH_PHY_CNTL2__ANE		(SWITCH__PORTS_PHYS<<0)
#define SWITCH_PHY_CNTL2__ANE_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<0)

/*
 * PHY Control 3 register fields
 */
#define SWITCH_PHY_CNTL3__FXE		(SWITCH__PORTS_PHYS<<17)
#define SWITCH_PHY_CNTL3__FXE_SET(set)	(((set)&(SWITCH__PORTS_PHYS))<<17)
#define SWITCH_PHY_CNTL3__DFEFI		(0x00000001<<16)
#define SWITCH_PHY_CNTL3__CBDE		(0x00000001<<15)
#define SWITCH_PHY_CNTL3__RPIC		(0x00000001<<14)
#define SWITCH_PHY_CNTL3__RPLFT		(0x00000003<<12)
#define SWITCH_PHY_CNTL3__RPLFT_2	(0x00000000<<12)
#define SWITCH_PHY_CNTL3__RPLFT_3	(0x00000001<<12)
#define SWITCH_PHY_CNTL3__RPLFT_4	(0x00000002<<12)
#define SWITCH_PHY_CNTL3__RPLFT_8	(0x00000003<<12)
#define SWITCH_PHY_CNTL3__RFGL		(0x00000001<<11)
#define SWITCH_PHY_CNTL3__RNT		(0x00000001<<10)
#define SWITCH_PHY_CNTL3__RTJD		(0x00000001<<9)
#define SWITCH_PHY_CNTL3__RRJE		(0x00000001<<8)
#define SWITCH_PHY_CNTL3__RADP		(0x00000001<<7)
#define SWITCH_PHY_CNTL3__IINSEL	(0x00000001<<6)
#define SWITCH_PHY_CNTL3__RSHC		(0x00000003<<4)
#define SWITCH_PHY_CNTL3__RSHC_VAL(val)	(((val)&(0x00000003))<<4)
#define SWITCH_PHY_CNTL3__PFRV		(0x00000003<<2)
#define SWITCH_PHY_CNTL3__PFRV_VAL(val)	(((val)&(0x00000003))<<2)
#define SWITCH_PHY_CNTL3__RBLL		(0x00000003<<0)
#define SWITCH_PHY_CNTL3__RBLL_VAL(val)	(((val)&(0x00000003))<<0)


/*
 * Interrupt mask register fields
 */
#define SWITCH_INT_MASK__CPUH		(0x00000001<<24)
#define SWITCH_INT_MASK__SDE		(0x00000001<<23)
#define SWITCH_INT_MASK__RDE		(0x00000001<<22)
#define SWITCH_INT_MASK__W1TE		(0x00000001<<21)
#define SWITCH_INT_MASK__W0TE		(0x00000001<<20)
#define SWITCH_INT_MASK__MI		(0x00000001<<19)
#define SWITCH_INT_MASK__PSC		(0x00000001<<18)
#define SWITCH_INT_MASK__BCS		(0x00000001<<16)
#define SWITCH_INT_MASK__MD		(0x00000001<<15)
#define SWITCH_INT_MASK__GQF		(0x00000001<<14)
#define SWITCH_INT_MASK__CPUQ		(0x00000001<<13)
#define SWITCH_INT_MASK__P5QF		(0x00000001<<11)
#define SWITCH_INT_MASK__P4QF		(0x00000001<<10)
#define SWITCH_INT_MASK__P3QF		(0x00000001<<9)
#define SWITCH_INT_MASK__P2QF		(0x00000001<<8)
#define SWITCH_INT_MASK__P1QF		(0x00000001<<7)
#define SWITCH_INT_MASK__P0QF		(0x00000001<<6)
#define SWITCH_INT_MASK__LDF		(0x00000001<<5)
#define SWITCH_INT_MASK__HDF		(0x00000001<<4)
#define SWITCH_INT_MASK__RLD		(0x00000001<<3)
#define SWITCH_INT_MASK__RHD		(0x00000001<<2)
#define SWITCH_INT_MASK__SLD		(0x00000001<<1)
#define SWITCH_INT_MASK__SHD		(0x00000001<<0)
#define SWITCH_INT_MASK__ALL_INTS	(SWITCH_INT_MASK__CPUH	|\
					 SWITCH_INT_MASK__SDE	|\
					 SWITCH_INT_MASK__RDE	|\
					 SWITCH_INT_MASK__W1TE	|\
					 SWITCH_INT_MASK__W0TE	|\
					 SWITCH_INT_MASK__MI	|\
					 SWITCH_INT_MASK__PSC	|\
					 SWITCH_INT_MASK__BCS	|\
					 SWITCH_INT_MASK__MD	|\
					 SWITCH_INT_MASK__GQF	|\
					 SWITCH_INT_MASK__CPUQ	|\
					 SWITCH_INT_MASK__P5QF	|\
					 SWITCH_INT_MASK__P4QF	|\
					 SWITCH_INT_MASK__P3QF	|\
					 SWITCH_INT_MASK__P2QF	|\
					 SWITCH_INT_MASK__P1QF	|\
					 SWITCH_INT_MASK__P0QF 	|\
					 SWITCH_INT_MASK__LDF	|\
					 SWITCH_INT_MASK__HDF	|\
					 SWITCH_INT_MASK__RLD	|\
					 SWITCH_INT_MASK__RHD	|\
					 SWITCH_INT_MASK__SLD	|\
					 SWITCH_INT_MASK__SHD)

#define SWITCH_TIMER_INT__TOS		(0x00000001<<0)

#if 0
#define SWITCH_MEM_CONT__SR0S		(0x00000007<<16)
#define SWITCH_MEM_CONT__SR0S_DISABLED	(0x00000000<<16)
#define SWITCH_MEM_CONT__SR0S_512KB	(0x00000001<<16)
#define SWITCH_MEM_CONT__SR0S_1MB	(0x00000002<<16)
#define SWITCH_MEM_CONT__SR0S_2MB	(0x00000003<<16)
#define SWITCH_MEM_CONT__SR0S_4MB	(0x00000004<<16)
#define SWITCH_MEM_CONT__SR0S_8MB	(0x00000005<<16)
#define SWITCH_MEM_CONT__SR0S_RES1	(0x00000006<<16)
#define SWITCH_MEM_CONT__SR0S_RES2	(0x00000007<<16)
#else
#define SWITCH_MEM_CONT__SR0S		(0x00000007<<8)
#define SWITCH_MEM_CONT__SR0S_DISABLED	(0x00000000<<8)
#define SWITCH_MEM_CONT__SR0S_512KB	(0x00000001<<8)
#define SWITCH_MEM_CONT__SR0S_1MB	(0x00000002<<8)
#define SWITCH_MEM_CONT__SR0S_2MB	(0x00000003<<8)
#define SWITCH_MEM_CONT__SR0S_4MB	(0x00000004<<8)
#define SWITCH_MEM_CONT__SR0S_8MB	(0x00000005<<8)
#define SWITCH_MEM_CONT__SR0S_RES1	(0x00000006<<8)
#define SWITCH_MEM_CONT__SR0S_RES2	(0x00000007<<8)
#endif

#define SWITCH_MEM_CONT__SDR1E		(0x00000001<<5)

#define SWITCH_MEM_CONT__SDRS		(0x00000007<<0)
#define SWITCH_MEM_CONT__SDRS_RES1	(0x00000000<<0)
#define SWITCH_MEM_CONT__SDRS_1Mx32	(0x00000001<<0)
#define SWITCH_MEM_CONT__SDRS_2Mx32	(0x00000002<<0)
#define SWITCH_MEM_CONT__SDRS_4Mx32	(0x00000003<<0)
#define SWITCH_MEM_CONT__SDRS_16Mx32	(0x00000004<<0)
#define SWITCH_MEM_CONT__SDRS_32Mx32	(0x00000005<<0)
#define SWITCH_MEM_CONT__SDRS_RES2	(0x00000006<<0)
#define SWITCH_MEM_CONT__SDRS_RES3	(0x00000007<<0)

/*
 * Corega CG-LBSTD2PU Appened
 */
#define SWITCH_MEM_CONT__SRAM1S_DISABLED	(0x00000000<<16)
#define SWITCH_MEM_CONT__SRAM1S_512KB		(0x00000001<<16)
#define SWITCH_MEM_CONT__SRAM1S_1MB		(0x00000002<<16)
#define SWITCH_MEM_CONT__SRAM1S_2MB		(0x00000003<<16)
#define SWITCH_MEM_CONT__SRAM1S_4MB		(0x00000004<<16)
#define SWITCH_MEM_CONT__SRAM1S_8MB		(0x00000005<<16)
#define SWITCH_MEM_CONT__SRAM1S_RES1		(0x00000006<<16)
#define SWITCH_MEM_CONT__SRAM1S_RES2		(0x00000007<<16)

/*
 * GPIO_conf0 : B8h(Base 0x12000000)
 * |    31 -- 24   |    23 -- 16   |   15 -- 08    |    07 -- 01   |
 * | OutPut Value  | Output Enbale | Input Value   |               |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|   reserved    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 */
#define SWITCH_GPIO_CONF0_GPIO0_OUT		(0x0010010000)
#define SWITCH_GPIO_CONF0_GPIO1_OUT		(0x0020020000)
#define SWITCH_GPIO_CONF0_GPIO2_OUT		(0x0040040000)
#define SWITCH_GPIO_CONF0_GPIO3_OUT		(0x0080080000)
#define SWITCH_GPIO_CONF0_GPIO4_OUT		(0x0101000000)
#define SWITCH_GPIO_CONF0_GPIO5_OUT		(0x0202000000)
#define SWITCH_GPIO_CONF0_GPIO6_OUT		(0x0404000000)
#define SWITCH_GPIO_CONF0_GPIO7_OUT		(0x0808000000)
#endif /* ADM51xx_SWITCH_H */
