#ifdef CONFIG_ADM5120

#include <asm/addrspace.h>

#define ADM5120_UART1_BASE	0x12800000
#define ADM5120_UART0_BASE	0x12600000
#define ADM5120_SYSC_BASE	0x12400000
#define ADM5120_INTC_BASE	0x12200000
#define ADM5120_SCR_BASE	0x12000000
#define ADM5120_MIPS_BASE	0x11a00000
#define ADM5120_PCIIO_BASE	0x11500000
#define ADM5120_PCIIO_END	(0x115ffff0-1)
#define ADM5120_PCI_CONFIG_ADDR	0x115ffff0
#define ADM5120_PCI_CONFIG_DATA	0x115ffff8
#define ADM5120_PCIMEM_BASE	0x11400000
#define ADM5120_PCIMEM_END	0x114fffff
#define ADM5120_USB_BASE	0x11200000
#define ADM5120_MPMC_BASE	0x11000000

#define SOFTWARE_RESET		0x1
#define SW_CPU_PORT_DISABLE	0x00000001
#define SW_DISABLE_PORT_MASK	0x0000003F

/*
 * CG-LBSTD2PU ADM5120 RTC (spi 3wire)
 *  Append 2008.03.14 T.Yoshida
 */
#define GPIOL_INPUT_MODE	0x00
#define GPIOL_OUTPUT_LOW	0x02
#define GPIOL_OUTPUT_HIGH	0x03
extern int spi_open(int);
extern void spi_close(void);
extern void spi_read(u_int8_t *data, int count);
extern void spi_write(u_int8_t *data, int count);
extern void spi_exchange(u_int8_t *data, int count);
extern void spi_enable(void);
extern void spi_disable(void);

#endif
