/*
 * (C) Copyright 2007
 *  Tooru Yoshida <yoshida@libertysystem-factory.co.jp>
 *  Corega CG-LBSTD2PU (ADM5120)
 *
 * (C) Copyright 2006
 * Robert Delien, <robert@delien.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Config header file for Infineon/ADMtek ADM5120 SoC
 * This Soc is used in several broadband routers. A long list of
 * routers using this SoC be found here:
 * http://www.linux-mips.org/wiki/Adm5120#Products_based_on_the_ADM5120
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#include <adm5120_glb.h>

#define CONFIG_MIPS32		1	/* MIPS 4Kc CPU core	*/
#define CONFIG_ADM5120		1	/* on the ADM5120 SoC	*/
#define CONFIG_LBSTD2PU		1	/* Corega CG-LBSTD2PU 	*/

/* LITTLE ENDIAN */
#define __LITTLE_ENDIAN		1
#define CFG_LITTLE_ENDIAN	1

/* 175 MHz clock for the MIPS core */
#define CPU_CLOCK_RATE		175000000

#define CONFIG_BOOTDELAY	5	/* autoboot after 5 seconds	*/

#define CONFIG_TIMESTAMP	1	/* Print image info with timestamp */

#define CONFIG_BOOTFILE		lbstd2pu/uImage
#define CONFIG_LOADADDR		0x81000000

/*
 *  * Corega CG-LBSTD2PU
 *   * PREBOOT and EXTRA_ENV
 *    * Append 2008.09.11 T.Yoshida
 *     */
#define CONFIG_PREBOOT "echo;"\
        "echo Type [boot]       to mount Flash root filesystem;"        \
        "echo Type [run kupd]      for the Kernel Update;"              \
        "echo"

#define CONFIG_EXTRA_ENV_SETTINGS					\
	"kupd=era 0xbfc80000 +278520;tftp 0x81000000 ${bootfile}"	\
        "cp.b 0x81000000 0xbfc80000 ${filesize}\0"			\
	""

#define CONFIG_BOOTARGS		"console=ttyS0,115200 root=/dev/mtdblock2 mem=64M"
#define CONFIG_BOOTCOMMAND	"bootm 0xBFC80000"

#define CONFIG_BZIP		1	/* bzip */

/*
 * Corega CG-LBSTD2PU PCI Config
 */
#if 0
#define CONFIG_PCI		1
#define CONFIG_PCI_PNP		1	/* PCI Plug and Play */
#endif

/*
 * 2007.09.27 T.Yoshida Corega CG-LBSTD2PU Command Config Set
 */
#define CONFIG_COMMANDS		(CONFIG_CMD_DFL		|\
				 CFG_CMD_ASKENV		|\
				 CFG_CMD_AUTOSCRIPT	|\
				 CFG_CMD_BDI		|\
				 CFG_CMD_BSP		|\
				 CFG_CMD_DATE		|\
				 CFG_CMD_DHCP		|\
				 CFG_CMD_DIAG		|\
				 CFG_CMD_ELF		|\
				 CFG_CMD_ENV		|\
				 CFG_CMD_FLASH		|\
				 CFG_CMD_JFFS2		|\
				 CFG_CMD_NET		|\
				 CFG_CMD_NFS		|\
				 CFG_CMD_PCI		|\
				 CFG_CMD_REGINFO	|\
				 CFG_CMD_SDRAM		|\
				 CFG_CMD_PING)
#include <cmd_confdefs.h>

/*
 * Miscellaneous configurable options
 */
#define CFG_LONGHELP				/* undef to save memory	     */
#define	CFG_PROMPT		"ADM5120 # "	/* Monitor Command Prompt    */
#define CFG_CBSIZE		256		/* Console I/O Buffer Size   */
#define CFG_PBSIZE		(CFG_CBSIZE+sizeof(CFG_PROMPT)+16)  /* Print Buffer Size */
#define CFG_MAXARGS		16		/* max number of command args*/

//#define CFG_MALLOC_LEN		128*1024
#define CFG_MALLOC_LEN		3072*1024

#define CFG_BOOTPARAMS_LEN	128*1024

#define CFG_CP0_COUNT_RATE	((CPU_CLOCK_RATE)/2) /* 87500000 */
#define CFG_HZ			((CPU_CLOCK_RATE)/2)

#define CFG_SDRAM_BASE		0x80000000
#define CONFIG_NR_DRAM_BANKS	2		/* SDRAM Bank */
#define CFG_SDRAM_MAX		0x04000000	/* Maximum 64MB of SDRAM */
#define CFG_SDRAM_SIZE		0x04000000	/* Maximum 64MB of SDRAM */
#define CFG_LOAD_ADDR		0x80000000	/* default load address */
#define CFG_INIT_SP_OFFSET	0x00040000	/* Initial stack at 512kiB	*/

#define CFG_MEMTEST_START	(CFG_SDRAM_BASE)
#define CFG_MEMTEST_END		((CFG_SDRAM_BASE)+(CFG_INIT_SP_OFFSET))
#define CFG_SCR_BASE		ADM5120_SCR_BASE

#define CONFIG_MEMSIZE_IN_BYTES	1


/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#define CFG_FLASH_CFI		1	/* flash is CFI compatible	*/
#define CFG_FLASH_CFI_DRIVER	1	/* Use common CFI driver	*/
#define CFG_FLASH_EMPTY_INFO		/* print 'E' for empty sector	*/
#define CFG_MAX_FLASH_SECT	256	/* max number of sectors on one chip */
#define CFG_MAX_FLASH_BANKS	2	/* max number of memory banks */
#define CFG_FLASH_PROTECTION	1	/* Flash Protection */
#define CFG_FLASH_CFI_WIDTH	0x02	/* Flash port width 16Bit */

/*
 * Flash Memort Bank #0 MX29LV320CBTC-70G x16 CS0
 *  U-BOOT and Kernel Area
 */
#define PHYS_FLASH		0xBFC00000	
#define CFG_FLASH_BASE		PHYS_FLASH
#define PHYS_FLASH_SIZE		0x00400000	/* 4MB */
/*
 * Flash Memory Bank #1 JS28F128J3D75 16MB CS1
 *  UserLand Area
 */
#define PHYS_FLASH_1		0xB0000000
#define CFG_FLASH_BASE_1	PHYS_FLASH_1
#define PHYS_FLASH_SIZE_1	0x01000000	/* 16MB */

#define CFG_FLASH_BANKS_LIST { CFG_FLASH_BASE , CFG_FLASH_BASE_1 }

/* The following #defines are needed to get flash environment right */
#define CFG_MONITOR_BASE	TEXT_BASE
#define CFG_MONITOR_LEN		(192 << 10)

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(20 * CFG_HZ)	/* Timeout for Flash Erase in ms */
#define CFG_FLASH_WRITE_TOUT	(2 * CFG_HZ)	/* Timeout for Flash Write in ms */

/*
 * Address and size of Primary Environment Sector
 * Corega CG-LBSTD2PU Boot Parameter Area is 0xBFC70000 - 0xBFC80000
 */
#define CFG_ENV_IS_IN_FLASH	1
#define CFG_ENV_ADDR		0xBFC50000	/* IPL Boot Parameter */
#define CFG_ENV_SIZE		0x00010000
#define CFG_ENV_SECT_SIZE	0x00010000	/* Sector Size is 0xBFC10000 0x10000 */
#define CONFIG_ENV_OVERWRITE	1	/* Enviroment OverWrite On */
//#define CONFIG_USE_BUFFER_WRITE	1

/*
 * TFTP Load to Flash Direct Write Option
 */
//#define CFG_DIRECT_FLASH_TFTP


/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#define CFG_DCACHE_SIZE		8192	/*  8 kiB data cache		*/
#define CFG_ICACHE_SIZE		8192	/*  8 kiB instruction cache	*/
#define CFG_CACHELINE_SIZE	16	/* 16 Byte cache line size	*/

/*-----------------------------------------------------------------------
 * Serial Configuration
 */
#define CFG_PL010_SERIAL
#define CFG_UART_PL010_CLOCK	62500000	/* 62.5MHz in AMD5120P */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }
#define CFG_SERIAL0		0xB2600000
#define CFG_SERIAL1		0xB2800000
#define CONFIG_CONS_INDEX	0
#define CONFIG_BAUDRATE		115200
#define CONFIG_PL01x_PORTS	{ (void *) (CFG_SERIAL0), (void *) (CFG_SERIAL1) }

/*-----------------------------------------------------------------------
 * Console configuration
 */
#define CFG_HUSH_PARSER			/* Enable HUSH shell parser	*/
#define CFG_PROMPT_HUSH_PS2	"> "	/* Configure HUSH sec. prompt	*/
#define CONFIG_CMDLINE_EDITING		/* Enable command line editing	*/

/*-----------------------------------------------------------------------
 *  Network Configuration
 */
#define CONFIG_ADM51xx_SWITCH	1
#define CONFIG_ADM51xx_SWITCH_BASE	KSEG1ADDR(0x12000000)
#define CONFIG_NET_MULTI 	1

/*
 * Corega CG-LBSTD2PU
 *  TFTP and NFS Server Default IP Address,
 *  Network Default Gateway Address,
 *  Network Netmask
 *
 *  When the setting is changed, it changes from the console 
 *  of U-BOOT by the setenv command. 
 *  Ex: setenv ipaddr 192.168.0.10
 *
 */
#define CONFIG_SERVERIP       	192.168.1.10    /* IP address of tftp server */
#define CONFIG_IPADDR         	192.168.1.250   /* Our IP address */
#define CONFIG_GATEWAYIP	192.168.1.254	/* Default Gateway */
#define CONFIG_NETMASK        	255.255.255.0   /* Our net mask */
#define CONFIG_HOSTNAME		cg-lbstd2pu	/* Default Host Name */

/*
 * RTC DS1305 Real Time Clock
 *  Append 2008.03.14 T.Yoshida
 */
#define CONFIG_ADM5120_RTC
/*
 * MAC Address Check
 *  Append 2008.10.01 T.Yoshida
 */
#define CONFIG_LBSTD2PU_MACCHK
#define CONFIG_ETHADDR		00:0A:79:AE:50:02
#define CONFIG_ETH1ADDR		00:0A:79:AE:50:03

#endif	/* __CONFIG_H */
